{ quelques outils pour faire rapidement des formes }
{$N+,E+}
unit ZTools;

interface

uses ZSolid;

type
	reel=single; { changer le type rel si pas de coprococesseur }
	TVectR3=array[0..2] of reel;
	TSurfaceProc=procedure(var P:TVectR3;u,v:integer);
	TCourbeProc=procedure(var P:TVectR3;u:integer);

function Surface(DrawP:TSurfaceProc;faceu,facev:integer;color,status:integer):integer;
function Courbe(DrawP:TCourbeProc;pas:word;color,status:integer):integer;


function Pave(rx,ry,rz:reel;color,status:integer):integer;
function Ellipsoid(rx,ry,rz:reel;face:word;color,status:integer):integer;
function Tore(d,r:reel;face:word;color,status:integer):integer;
function Ellipse(rx,ry:reel;pas:word;color,status:integer):integer;
function Cylindre(rx,ry,h:reel;pas:word;color,status:integer):integer;

implementation

function Pave(rx,ry,rz:reel;color,status:integer):integer;
var
	nbpoly,nbpts,x1,y1,z1:integer;
	PS:integer;
	x,y,z:reel;
begin
	nbpoly:=6;
	nbpts:=8;
	PS:=CreateSolid(nbpts,nbpoly,color,status or Z_BACK);

	for z1:=0 to 1 do
	for y1:=0 to 1 do
	for x1:=0 to 1 do begin
		if x1=0 then x:=-rx else x:=rx;
		if y1=0 then y:=-ry else y:=ry;
		if z1=0 then z:=-rz else z:=rz;
		DPT(PS,z1*4+y1*2+x1,round(x),round(y),round(z));
	end;

	DF(PS,4,0,1,3,2);
	DF(PS,4,2,3,7,6);
	DF(PS,4,1,5,7,3);
	DF(PS,4,0,2,6,4);
	DF(PS,4,4,6,7,5);
	DF(PS,4,0,4,5,1);
	Pave:=PS;
end;

{ dessin d'une surface (borne) dfinie par des paramtres }
function Surface(DrawP:TSurfaceProc;faceu,facev:integer;color,status:integer):integer;
var	P:TVectR3;
	r:reel;
	nbpoly,nbpts:word;
	PS:integer;
	u1,v1,n,u,v,i,j:integer;

begin
	nbpts:=faceu*facev;
	nbpoly:=(faceu-1)*(facev-1);
	PS:=CreateSolid(nbpts,nbpoly,color,status);
	n:=0;
	for u:=0 to faceu-1 do begin
		for v:=0 to facev-1 do begin
			DrawP(p,u,v);
			DPT(PS,n,round(p[0]),round(p[1]),round(p[2]));
			inc(n);
		end;
	end;

	for u:=0 to faceu-2 do
	for v:=0 to facev-2 do begin
		u1:=u+1;
		v1:=v+1;
		DF(PS,4,u*faceu+v,u1*faceu+v,u1*faceu+v1,u*faceu+v1);
	end;
     Surface:=PS;
end;


function Ellipsoid(rx,ry,rz:reel;face:word;color,status:integer):integer;
var	k,l,i,j,ps:integer;
	s,u,v:reel;

begin
	ps:=CreateSolid((face-2)*face+2,(face-1)*face,color,status or Z_BACK);
	DPT(ps,0,0,0,round(rz));
	DPT(ps,1,0,0,round(-rz));
	for i:=0 to face-3 do begin
		for j:=0 to face-1 do begin
			u:=j/face*2*pi;
			v:=(i+1)/(face-1)*pi;
			s:=sin(v);
			DPT(ps,2+i*face+j,round(cos(u)*s*rx),round(sin(u)*s*ry),round(cos(v)*rz));
		end;
	end;

	for i:=0 to face-4 do
	for j:=0 to face-1 do begin
		k:=2+i*face;
         	l:=j+1;
		if l>=face then l:=0;
          DF(ps,4,k+j,k+l,k+l+face,k+j+face);
	end;

	for j:=0 to face-1 do begin
         	l:=j+1;
		if l>=face then l:=0;
		DF(ps,3,0,2+l,2+j,0);
		k:=2+(face-3)*face;
		DF(ps,3,1,k+j,k+l,0);
	end;
	Ellipsoid:=ps;
end;


function Tore(d,r:reel;face:word;color,status:integer):integer;
var	ps:integer;
	i1,j1,i,j:integer;
	u,v,k:reel;

begin
	ps:=CreateSolid(face*face,face*face,color,status or Z_BACK);
	for i:=0 to face-1 do begin
		for j:=0 to face-1 do begin
			u:=i/face*2*pi;
			v:=j/face*2*pi;
			k:=r*cos(v);
			DPT(ps,i*face+j,round(cos(u)*(d+k)),round(sin(u)*(d+k)),round(r*sin(v)));
		end;
	end;

	for i:=0 to face-1 do
	for j:=0 to face-1 do begin
		i1:=i+1;
		if i1>=face then i1:=0;
		j1:=j+1;
		if j1>=face then j1:=0;
          DF(ps,4,face*i+j,face*i+j1,face*i1+j1,face*i1+j);
	end;

	Tore:=ps;
end;

function Cylindre(rx,ry,h:reel;pas:word;color,status:integer):integer;
var i,hs,x,y:integer;
begin
	hs:=CreateSolid(2*(pas+1),3*pas,color,status or Z_BACK);
	DPT(hs,2*pas,0,0,0);
	DPT(hs,2*pas+1,0,0,round(h));

	for i:=0 to pas-1 do begin
		x:=round(cos(i/pas*2*pi)*rx);
		y:=round(sin(i/pas*2*pi)*ry);
		DPT(hs,i,x,y,0);
		DPT(hs,pas+i,x,y,round(h));
	end;
     for i:=0 to pas-1 do begin
		DF(hs,4,(i+1) mod pas,i,pas+i,pas+((i+1) mod pas));
		DF(hs,3,2*pas,i,(i+1) mod pas,0);
		DF(hs,3,pas+i,2*pas+1,pas+((i+1) mod pas),0);
	end;
	Cylindre:=hs;
end;



{ courbes paramtres }

function Courbe(DrawP:TCourbeProc;pas:word;color,status:integer):integer;
var 	u:integer;
	p:TVectR3;
	PS:integer;
begin
	PS:=CreateSolid(pas,pas-1,color,status);
	for u:=0 to pas-1 do begin
		DrawP(p,u);
		DPT(PS,u,round(p[0]),round(p[1]),round(p[2]));
	end;
	for u:=0 to pas-2 do begin
		DF(PS,2,u,u+1,0,0);
	end;
	Courbe:=PS;
end;


var	rxEl1,ryEl1:reel;
	pasEl1:word;


procedure DPEL1(var P:TVectR3;u:integer); far;
var u1:reel;
begin
	u1:=u/(PasEl1-1)*2*pi;
	P[0]:=cos(u1)*rxEl1;
	P[1]:=sin(u1)*ryEl1;
	P[2]:=0;
end;

function Ellipse(rx,ry:reel;pas:word;color,status:integer):integer;
begin
	rxEl1:=rx;
	ryEl1:=ry;
	pasEl1:=pas;
	Ellipse:=Courbe(DPEl1,pas,color,status);
end;

end.