{$F-,R-,S-,N-,G-,I-}
{$M 1024,0,0 }
{ Driver pour utiliser DSOUND et RPMOD dans tous les langages volus }
program SndDRV;

uses dos,dsound,rpmod,rpmodio;

const
	INTMIN=$80;
	INTMAX=$BF;
	IDSTR=$444E5344;
	IDOFS=$0000;

procedure dummy; assembler;
asm
	dd IDSTR		{ identificateur }
	dd 0			{ pointeur sur l'ancienne interruption }
	dw 0			{ segment du programme }
end;

procedure MyInt(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: WORD); interrupt;
type dw=record l,h:word end;
var l:longint;
	p1:TDSMalloc;
	p2:TDSFree;
begin
	asm
		sti
	end;
	case AX of
	{ dsound }
	1: AX:=StartDSound(TDSoundInfo(ptr(ES,BX)^));
	2: AX:=StopDSound;
	3: AX:=StartDSoundIN(TDSoundInfo(ptr(ES,BX)^));
	4: AX:=StopDSoundIN;
	5: AX:=GetDSoundStatus;
	6: AX:=GetCardInfo(TCardInfo(ptr(ES,BX)^));
	7: GetCardGlobalInfo(TCardGlobalInfo(ptr(ES,BX)^));
	8: AX:=GetAccurateFreq(BX,(longint(DX) shl 16) or CX,SI);
	9: begin
		@p1:=ptr(ES,BX);
		@p2:=ptr(DX,CX);
		SetDSMemProc(p1,p2,DS);
	end;
	10:SetDSMemPtr(ptr(ES,BX),(longint(DX) shl 16) or CX);
	11: begin
		l:=GetDSMemSize;
		AX:=dw(l).l;
		DX:=dw(l).h;
	end;

	{ rpmod }
	20: AX:=StartRPMod(TDsoundInfo(ptr(ES,BX)^),TRPMModule(ptr(DX,CX)^));
	21: AX:=StopRPMod;
   22: SetRPMVoice(BX,CX);
	23: SetRPMVolOut(BX,CX);
	24: SetRPMPattern(BX);
	25: GetRPMStatus(TRPMStatus(ptr(ES,BX)^));

	{ rpmodio }
	30: AX:=LoadMod(TRPMModule(ptr(ES,BX)^),string(ptr(DX,CX)^));
	31: FreeMod(TRPMModule(ptr(ES,BX)^));

	end;
end;

{ recherche d'une interruption libre, renvoie -1 si rien }
function FreeInt:integer;
var int:word;
	p:pointer;
begin
	for int:=INTMIN to INTMAX do begin
		getintvec(int,p);
		if p=nil then begin
			FreeInt:=int;
			exit;
		end;
	end;
	FreeInt:=-1;
end;

{ si le driver est dj charg, renvoie son numro d'interruption }
function FindDrvInt:integer;
var int:word;
	p:pointer;

begin
	for int:=INTMIN to INTMAX do begin
		getintvec(int,p);
		if p<>nil then begin
			if meml[seg(p^):IDOFS]=IDSTR then begin
				FindDrvInt:=int;
				exit;
			end;
		end;
	end;
	FindDrvInt:=-1;
end;

{ retire le driver de la mmoire }
procedure RemoveDRV(int:word);
var	oldint,p:pointer;
		reg:registers;
		segbe,segpsp:word;
begin
	getintvec(int,p);
	{ vecteur d'interruption }
   setintvec(int,pointer(meml[seg(p^):IDOFS+4]));
	{ libration de la RAM }
	segpsp:=memw[seg(p^):IDOFS+8];
	segbe:=memw[segpsp:$2C];
	reg.ES:=segpsp;
	reg.AH:=$49;
	msdos(reg);
	reg.ES:=segbe;
	reg.AH:=$49;
	msdos(reg);
end;

procedure InstallDrv(int:word);
var	p:pointer;
begin
	p:=@dummy;
	getintvec(int,pointer(ptr(seg(p^),ofs(p^)+4)^));
	word(ptr(seg(p^),ofs(p^)+8)^):=PrefixSeg;
	setintvec(int,@MyInt);
	InitDSound;
	keep(0);
end;


var
	RemoveOpt:boolean;
	QuietOpt:boolean;
	HelpOpt:boolean;
	int:integer;

procedure ScanOpt;
var p:^string;
	i,j:integer;
	ch:char;
begin
	RemoveOpt:=false;
	QuietOpt:=false;
	HelpOpt:=false;
	p:=ptr(PrefixSeg,$80);
	for j:=1 to length(p^) do begin
			case upcase(p^[j]) of
			'R': RemoveOpt:=true;
			'Q': QuietOpt:=true;
			'?','H': HelpOpt:=true;
			end;
	end;
end;

type string2=string[2];
function hex(a:byte):string2;
const
	h:array[0..15] of char='0123456789ABCDEF';
var
	s:string2;
begin
	s[0]:=#2;
	s[1]:=h[a shr 4];
	s[2]:=h[a and $F];
	hex:=s;
end;


begin
	ScanOpt;
	if not QuietOpt then begin
		Writeln('SNDDRV.EXE par F. Bellard (c) 1993 ESAT Software');
		Writeln('Driver sonore rsident.');
		Writeln;
	end;
	if HelpOpt then begin
		Writeln('Commandes:');
		Writeln('H,? : Affichage de cette aide');
		Writeln('R   : Retirer le driver de la RAM');
		Writeln('Q   : Pas d''affichage  l''cran');
		Writeln;
		Halt(0);
	end;
   if RemoveOpt then begin
		int:=FindDrvInt;
		if int<0 then begin
			if not QuietOpt then begin
				Writeln('Pas de driver install');
			end;
			halt(1);
		end;
		RemoveDrv(int);
		if not QuietOpt then begin
			Writeln('Driver retir de la mmoire');
		end;
	end
	else begin
		int:=FindDrvInt;
		if (int>=0) then begin
			if not QuietOpt then begin
				Writeln('Driver dj install sur l''INT ',hex(int),'H');
			end;
			halt(0);
		end;
		int:=FreeInt;
		if (int<0) then begin
			if not QuietOpt then begin
				Writeln('Pas d''interruption disponible: driver non install');
			end;
			halt(1);
		end;
		if not QuietOpt then begin
			Writeln('Driver install sur l''INT ',hex(int),'H');
		end;
		InstallDrv(int);
	end;
end.
	


